/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2510;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3749;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class RoadSignFeature
extends class_3031<class_3111> {
    private static final class_2680 COBBLE = class_2246.field_10445.method_9564();
    private static final class_2680 MOSSY_COBBLE = class_2246.field_9989.method_9564();
    private static final class_2680 FENCE = class_2246.field_10020.method_9564();
    private static final class_2680 WALL = class_2246.field_10625.method_9564();
    private static final class_2680 MOSSY_WALL = class_2246.field_9990.method_9564();
    private static final class_2680 TRAPDOOR = class_2246.field_10323.method_9564();
    private static final class_2680 LANTERN = (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
    private static final class_2680 LANTERN_DOWN = class_2246.field_16541.method_9564();
    private static final class_2680 JAR = LANTERN;
    private static final class_2680 SLAB = class_2246.field_10071.method_9564();
    private static final class_2680 LOG = class_2246.field_10436.method_9564();
    private static final class_2680 STONE_SLAB = class_2246.field_10454.method_9564();
    private static final class_2680 STONE = class_2246.field_10340.method_9564();
    private static final class_2680 STAIR = class_2246.field_10440.method_9564();
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_2680 PATH = class_2246.field_10194.method_9564();
    private static final class_2680 SANDSTONE_PATH = class_2246.field_10467.method_9564();

    public RoadSignFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public static boolean isNotSolid(class_1936 world, class_2338 pos) {
        return !world.method_16358(pos, state -> state.method_26212((class_1922)world, pos));
    }

    public boolean method_13151(class_5821<class_3111> pContext) {
        class_5281 reader = pContext.method_33652();
        class_5819 rand = pContext.method_33654();
        class_2338 pos = pContext.method_33655();
        pos = pos.method_10074();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                for (int k = 1; k <= 4; ++k) {
                    if ((Math.abs(i) == 2 || Math.abs(j) == 2) && k == 1) continue;
                    reader.method_8652(pos.method_10069(i, k, j), ModRegistry.STRUCTURE_TEMP.get().method_9564(), 2);
                }
            }
        }
        float humidity = ((class_1959)reader.method_23753(pos).comp_349()).method_8715();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                reader.method_8652(pos.method_10069(i, -1, j), COBBLE, 2);
                class_2338 pathPos = pos.method_10069(i, 0, j);
                double dist = pos.method_10268((double)pathPos.method_10263(), (double)pathPos.method_10264(), (double)pathPos.method_10260()) / (double)5.2f;
                if ((double)rand.method_43057() < dist - 0.15) continue;
                boolean m = (double)humidity * 0.75 > (double)rand.method_43057();
                reader.method_8652(pathPos, m ? MOSSY_COBBLE : COBBLE, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.method_43057();
        pos = pos.method_10084();
        reader.method_8652(pos, m ? MOSSY_WALL : WALL, 2);
        pos = pos.method_10084();
        reader.method_8652(pos, FENCE, 2);
        pos = pos.method_10084();
        reader.method_8652(pos, FENCE, 2);
        reader.method_8652(pos.method_10084(), ModRegistry.BLOCK_GENERATOR.get().method_9564(), 2);
        return true;
    }

    public static void applyPostProcess(class_3218 level, class_2338 generatorPos, List<Pair<class_2338, class_6880<class_3195>>> foundVillages) {
        class_2338 pos = generatorPos.method_10087(2);
        class_2680 topState = TRAPDOOR;
        ArrayList<Pair> villages = new ArrayList<Pair>();
        for (Pair<class_2338, class_6880<class_3195>> r : foundVillages) {
            villages.add(Pair.of((Object)((int)class_3532.method_15355((float)((float)((class_2338)r.getFirst()).method_10268((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())))), (Object)((class_2338)r.getFirst())));
        }
        boolean inVillage = false;
        if (inVillage) {
            class_6880 b = level.method_23753(pos);
            class_2680 replace = b.method_40220(class_6908.field_36496) ? SANDSTONE_PATH : PATH;
            RoadSignFeature.replaceCobbleWithPath((class_1937)level, pos, replace);
        }
        if (!villages.isEmpty()) {
            class_2338 village2;
            int dist2;
            class_2338 village1;
            int dist1;
            class_5819 rand = level.field_9229;
            boolean twoSigns = true;
            if (villages.size() == 1 || 0.3 > (double)rand.method_43057() && (Integer)((Pair)villages.get(0)).getFirst() > 192) {
                dist1 = (Integer)((Pair)villages.get(0)).getFirst();
                village1 = (class_2338)((Pair)villages.get(0)).getSecond();
                dist2 = dist1;
                village2 = village1;
                twoSigns = false;
            } else {
                boolean inv = rand.method_43056();
                dist1 = (Integer)((Pair)villages.get(inv ? 0 : 1)).getFirst();
                village1 = (class_2338)((Pair)villages.get(inv ? 0 : 1)).getSecond();
                dist2 = (Integer)((Pair)villages.get(inv ? 1 : 0)).getFirst();
                village2 = (class_2338)((Pair)villages.get(inv ? 1 : 0)).getSecond();
            }
            level.method_8501(pos, ModRegistry.SIGN_POST.get().method_9564());
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof SignPostBlockTile) {
                class_2350 backDir;
                float yaw;
                float diff;
                SignPostBlockTile tile = (SignPostBlockTile)class_25862;
                tile.setHeldBlock(class_2246.field_10020.method_9564());
                boolean left = rand.method_43056();
                SignPostBlockTile.Sign up = tile.getSignUp();
                SignPostBlockTile.Sign down = tile.getSignDown();
                up.setActive(true);
                up.setLeft(left);
                tile.pointToward(village1, true);
                down.setActive(twoSigns);
                down.setLeft(left);
                tile.pointToward(village2, false);
                if (Math.abs(up.yaw() - down.yaw()) > 90.0f) {
                    down.toggleDirection();
                    tile.pointToward(village2, false);
                }
                if (CommonConfigs.Building.WAY_SIGN_DISTANCE_TEXT.get().booleanValue()) {
                    tile.getTextHolder().setLine(0, RoadSignFeature.getSignText(dist1));
                    if (twoSigns) {
                        tile.getTextHolder().setLine(1, RoadSignFeature.getSignText(dist2));
                    }
                }
                class_2350 sideDir = (diff = class_3532.method_15381((float)(yaw = class_3532.method_15393((float)(90.0f + 360.0f * MthUtils.averageAngles((Float[])new Float[]{Float.valueOf((180.0f - up.yaw()) / 360.0f), Float.valueOf((180.0f - down.yaw()) / 360.0f)})))), (float)(backDir = class_2350.method_10150((double)yaw)).method_10144())) < 0.0f ? backDir.method_10170() : backDir.method_10160();
                ArrayList<class_2350> lampDir = new ArrayList<class_2350>();
                lampDir.add(backDir.method_10153());
                lampDir.add(backDir.method_10153());
                lampDir.add(backDir.method_10153());
                if (Math.abs(diff) > 30.0f) {
                    lampDir.add(sideDir.method_10153());
                }
                boolean hasGroundLantern = false;
                boolean hasFirefly = false;
                if (0.3 > (double)rand.method_43057() && class_3532.method_15356((float)(tile.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                    class_2338 stonePos = pos.method_10074().method_10081(backDir.method_10163());
                    if (rand.method_43056()) {
                        level.method_8652(stonePos, STONE_SLAB, 2);
                    } else {
                        level.method_8652(stonePos, (class_2680)STAIR.method_11657((class_2769)class_2510.field_11571, (Comparable)sideDir), 2);
                    }
                    stonePos = stonePos.method_10081(sideDir.method_10163());
                    level.method_8652(stonePos, STONE, 2);
                    if (0.35 > (double)rand.method_43057()) {
                        level.method_8652(stonePos.method_10084(), hasFirefly ? JAR : LANTERN_DOWN, 3);
                        hasGroundLantern = true;
                    }
                    if (!RoadSignFeature.isNotSolid((class_1936)level, (stonePos = stonePos.method_10081(sideDir.method_10163())).method_10074())) {
                        if (rand.method_43056()) {
                            level.method_8652(stonePos, STONE_SLAB, 2);
                        } else {
                            level.method_8652(stonePos, (class_2680)STAIR.method_11657((class_2769)class_2510.field_11571, (Comparable)sideDir.method_10153()), 2);
                        }
                    }
                }
                if (!hasGroundLantern) {
                    boolean doubleSided;
                    class_2680 light;
                    pos = pos.method_10086(2);
                    class_2680 class_26802 = light = hasFirefly ? JAR : LANTERN;
                    if (rand.method_43048(5) == 1) {
                        light = (class_2680)((class_2680)ModRegistry.CANDLE_HOLDERS.get(null).get().method_9564().method_11657((class_2769)CandleHolderBlock.LIT, (Comparable)Boolean.valueOf(true))).method_11657(CandleHolderBlock.FACE, (Comparable)class_2738.field_12473);
                    }
                    class_2350 dir = (class_2350)lampDir.get(rand.method_43048(lampDir.size()));
                    boolean bl = doubleSided = 0.25 > (double)rand.method_43057();
                    if (doubleSided) {
                        dir = dir.method_10170();
                    }
                    if (0.32 > (double)rand.method_43057()) {
                        topState = 0.32 > (double)rand.method_43057() ? TRAPDOOR : AIR;
                        WallLanternBlock wl = ModRegistry.WALL_LANTERN.get();
                        wl.placeOn(LANTERN_DOWN, pos.method_10074(), dir, (class_1937)level);
                        if (doubleSided) {
                            wl.placeOn(LANTERN_DOWN, pos.method_10074(), dir.method_10153(), (class_1937)level);
                        }
                    } else {
                        boolean isTrapdoor;
                        boolean bl2 = isTrapdoor = 0.4 > (double)rand.method_43057();
                        if (!isTrapdoor) {
                            topState = FENCE;
                        }
                        if (doubleSided) {
                            class_2338 backPos = pos.method_10093(dir.method_10153());
                            level.method_8652(backPos, isTrapdoor ? TRAPDOOR : FENCE, 2);
                            if (0.25 > (double)rand.method_43057()) {
                                topState = isTrapdoor ? SLAB : LOG;
                            }
                            level.method_8652(backPos.method_10074(), light, 3);
                        }
                        pos = pos.method_10093(dir);
                        class_2680 frontState = isTrapdoor ? TRAPDOOR : FENCE;
                        level.method_8652(pos, frontState, 2);
                        level.method_8652(pos.method_10074(), light, 3);
                    }
                }
            }
        } else {
            class_1799 book = new class_1799((class_1935)class_1802.field_8674);
            class_2487 com = new class_2487();
            class_2499 listTag = new class_2499();
            listTag.add((Object)class_2519.method_23256((String)"nothing here but monsters\n\n\n"));
            com.method_10566("pages", (class_2520)listTag);
            book.method_7980(com);
            class_2338 belowPos = generatorPos.method_10087(2);
            level.method_8501(belowPos, (class_2680)((class_2680)ModRegistry.NOTICE_BOARD.get().method_9564().method_11657((class_2769)NoticeBoardBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)NoticeBoardBlock.FACING, (Comparable)class_2350.class_2353.field_11062.method_10183(level.field_9229)));
            class_2586 class_25863 = level.method_8321(belowPos);
            if (class_25863 instanceof NoticeBoardBlockTile) {
                NoticeBoardBlockTile board = (NoticeBoardBlockTile)class_25863;
                board.setDisplayedItem(book);
            }
        }
        level.method_8652(generatorPos, topState, 3);
    }

    private static class_2561 getSignText(int d) {
        int s = d < 100 ? 10 : (d < 2000 ? 100 : 1000);
        return class_2561.method_43469((String)"message.supplementaries.road_sign", (Object[])new Object[]{(d + s / 2) / s * s});
    }

    private static void replaceCobbleWithPath(class_1937 world, class_2338 pos, class_2680 path) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                class_2338 pathPos;
                class_2680 state;
                if (Math.abs(i) == 2 && Math.abs(j) == 2 || i == 0 && j == 0 || !(state = world.method_8320(pathPos = pos.method_10069(i, -2, j))).method_27852(class_2246.field_10445) && !state.method_27852(class_2246.field_9989)) continue;
                world.method_8652(pathPos, path, 2);
            }
        }
    }
}

